Dim CharSet_InUse.b(7)
Dim CharSet_Picture(7,71,127)

Global charset_backcolorinuse
Global charset_choosen

Declare create_image()

Procedure charset_setautobackcolor()
  start_autobackcolor()
  For i=0 To 7
    For y=0 To 127
      For x=0 To 71
        If charset_inuse(i)<>0 And charset_picture(i,x,y)<>-1
          set_autobackcolor(Red(charset_picture(i,x,y)),Green(charset_picture(i,x,y)),Blue(charset_picture(i,x,y)))
        EndIf
      Next
    Next
  Next
  charset_backcolor=get_autobackcolor()
EndProcedure
Procedure Charset_CreateCompleteImage()
  CreateImage(#image_charset_all,72*4,128*2)
  charset_backcolorinuse=0
  If charset_autobackcolor
    charset_setautobackcolor()
  EndIf
  
  StartDrawing(ImageOutput())
  For i=0 To 7
    If i<4 : xx=i*72:yy=0 : Else : xx=(i-4)*72:yy=128 : EndIf
    
    For y=0 To 127
      For x=0 To 71
        If charset_inuse(i)=0 Or charset_picture(i,x,y)=-1
          color=charset_backcolor
        Else
          color=charset_picture(i,x,y)
          If color=charset_backcolor : charset_backcolorinuse=-1 : EndIf
        EndIf
        Plot(xx+x,yy+y,color)
      Next
    Next
  Next    
  StopDrawing()
EndProcedure
Procedure charset_createpictures(i)
  
  UseImage(#image_charset_pic1+i)
  StartDrawing(ImageOutput())
  For y=0 To 127
    For x=0 To 71
      If charset_inuse(i)=0 Or charset_picture(i,x,y)=-1
        color=charset_backcolor
      Else
        color=charset_picture(i,x,y)
        If color=charset_backcolor : charset_backcolorinuse=-1 : EndIf
      EndIf
      Plot(x,y,color)
    Next
  Next
  StopDrawing()
  SetGadgetState(#gadget_charset_pic1+i,ImageID())
EndProcedure
Procedure Charset_createpictures_ALL()
  If charset_autobackcolor
    charset_setautobackcolor()
  EndIf
  charset_backcolorinuse=0
  For i=0 To 7
    charset_createpictures(i)
  Next
EndProcedure

Procedure charset_CopyFromMain()
  a=-1
  For i=0 To 7
    If a<0 And charset_inuse(i)=0: a=i : EndIf
  Next
  If a>-1
    charset_inuse(a)=1
    For y=0 To 127
      For x=0 To 71
        charset_picture(a,x,y)=main_bild(x,y)
      Next
    Next
    Charset_createpictures_all()
  Else
    MessageRequester(#title_charset, language$(80), #PB_MessageRequester_Ok )
  EndIf
EndProcedure
Procedure charset_loadimagehelp(i)
  If OpenWindow(#window_charimp,0,0,136+25,136+25,#PB_Window_ScreenCentered,#title_charimp)
    If CreateGadgetList(WindowID())
      ImageGadget(#gadget_charimp_pic,  44,      4,72,128,UseImage(#image_charset_all))
      TextGadget(#gadget_charimp_text,0,128+4+4,136+25,20,language$(81),#pb_text_center)
      
      quit=0
      Repeat
        eventid=WaitWindowEvent()
        
        If EventWindowID()=#window_charimp
          UseWindow(#window_charimp)
          If eventid=#WM_LBUTTONDOWN
            ;testen, ob ein click in bild
            GetWindowRect_(GadgetID(#gadget_charimp_pic), @winrect.rect)
            GetCursorPos_(@mouse.point)
            x=(mouse\x-winrect\left):y=(mouse\y-winrect\top)          
            If X=>0 And x<72 And y=>0 And y<128
              quit=-1
            EndIf
          EndIf
        Else 
          If getForegroundWindow_()<>WindowID(#window_charimp)
            UseWindow(#window_charimp)
            ActivateWindow()
          EndIf
        EndIf
      Until quit
      
      UseImage(#image_charset_all)
      StartDrawing(ImageOutput())
      back=Point(x,y)
      For y=0 To 127
        For x=0 To 71
          color=Point(x,y):If color=back : color=-1 : EndIf
          charset_picture(i,x,y)=color
        Next
      Next
      StopDrawing()
      charset_inuse(i)=1
      charset_createpictures_all()
    EndIf
    CloseWindow(#window_charimp)
  EndIf
EndProcedure
Procedure charset_loadimage(i,file$)
  If FI_LoadImage(#image_charset_all,file$,0)
    charset_loadimagehelp(i)
    FreeImage(#image_charset_all)
  Else
    MessageRequester(#title_charset, language$(12)+Chr(13)+GetFilePart(file$), #PB_MessageRequester_Ok); kann datei nicht ffnen
  EndIf
EndProcedure
Procedure charset_clipboard(i)
  id=GetClipboardData(#PB_ClipboardImage) 
  If id>0
    CreateImage(#image_charset_all,72,128)
    StartDrawing(ImageOutput())
      DrawImage(id,0,0)
    StopDrawing()
    charset_loadimagehelp(i)
    FreeImage(#image_charset_all)
  Else
    MessageRequester(#title_charset, language$(73), #PB_MessageRequester_Ok); kann clipboard nicht importieren
  EndIf
EndProcedure
Procedure charset_loadcharset(file$)
  If FI_LoadImage(#image_charset_all,file$,0) 
    If OpenWindow(#window_charimp,0,0,72*4,128*2+25,#PB_Window_ScreenCentered,#title_charimp)
      If CreateGadgetList(WindowID())
        ImageGadget(#gadget_charimp_pic,  0,0       ,72*4,128*2,UseImage(#image_charset_all))
        TextGadget(#gadget_charimp_text,  0,128*2+5 ,72*4,   20,language$(81),#pb_text_center)
        
        quit=0
        Repeat
          eventid=WaitWindowEvent()
          
          If EventWindowID()=#window_charimp
            UseWindow(#window_charimp)
            If eventid=#WM_LBUTTONDOWN
              ;testen, ob ein click in bild
              GetWindowRect_(GadgetID(#gadget_charimp_pic), @winrect.rect)
              GetCursorPos_(@mouse.point)
              x=(mouse\x-winrect\left):y=(mouse\y-winrect\top)          
              If x=>0 And x<72*4 And y=>0 And y<128*128*2
                quit=-1
              EndIf
            EndIf
          Else 
            If getForegroundWindow_()<>WindowID(#window_charimp)
              UseWindow(#window_charimp)
              ActivateWindow()
            EndIf
          EndIf
        Until quit
        
        UseImage(#image_charset_all)
        StartDrawing(ImageOutput())
        back=Point(x,y)
        For i=0 To 7
          If i<4
            ofx=i*72:ofy=0
          Else
            ofx=(i-4)*72:ofy=128
          EndIf
          For y=0 To 127
            For x=0 To 71
              color=Point(ofx+x,ofy+y):If color=back : color=-1 : EndIf
              CharSet_Picture(i,x,y)=color
            Next
          Next
          charset_inuse(i)=1
        Next
        StopDrawing()        
        Charset_createpictures_ALL()
      EndIf
      CloseWindow(#window_charimp)
    EndIf
    FreeImage(#image_charset_all)
  Else
    MessageRequester(#title_charset, language$(12)+Chr(13)+GetFilePart(file$), #PB_MessageRequester_Ok); kann datei nicht ffnen
  EndIf
EndProcedure
Procedure charset_CreatePopup()
  CreatePopupMenu(#menu_charset_popup)
    MenuItem(#menu_charset_load,language$(8))
    MenuItem(#menu_charset_clipboard,language$(72))
    MenuBar()
    MenuItem(#menu_charset_save,language$(74))
    MenuItem(#menu_charset_expclip,language$(71))
    MenuBar()
    MenuItem(#menu_charset_clear,language$(28))
EndProcedure
Procedure open_CharSet()
  If win_charset_x=-1 : flag=#PB_Window_ScreenCentered :Else: flag=0 :EndIf
  If win_charset_hide : flag=flag|#pb_window_invisible :EndIf

  If OpenWindow(#window_charset,win_charset_x,win_charset_y,72*4+10,128*2+10+25+25,#PB_Window_SystemMenu|flag,#title_charset)
    If CreateGadgetList(WindowID())
      CreateImage(#image_charset_pic1,72,128)
      CreateImage(#image_charset_pic2,72,128)
      CreateImage(#image_charset_pic3,72,128)
      CreateImage(#image_charset_pic4,72,128)
      CreateImage(#image_charset_pic5,72,128)
      CreateImage(#image_charset_pic6,72,128)
      CreateImage(#image_charset_pic7,72,128)
      CreateImage(#image_charset_pic8,72,128)
      For i=0 To 7
        CharSet_InUse(i)=0
        For y=0 To 127
          For x=0 To 71
            CharSet_Picture(i,x,y)=-1
          Next
        Next
      Next
            
      ButtonImageGadget(#gadget_charset_pic1,5     ,5    ,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic2,5+72  ,5    ,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic3,5+72*2,5    ,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic4,5+72*3,5    ,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic5,5     ,5+128,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic6,5+72  ,5+128,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic7,5+72*2,5+128,72,128,UseImage(#image_charset_pic1))
      ButtonImageGadget(#gadget_charset_pic8,5+72*3,5+128,72,128,UseImage(#image_charset_pic1))
      
      ButtonGadget(#gadget_charset_save,         5,5+128*2+5   ,142,20,language$(27))
      ButtonGadget(#gadget_charset_load,         5,5+128*2+5+25,142,20,language$(8))
      If charset_autobackcolor
        ButtonGadget(#gadget_charset_back,  10+143,5+128*2+5   ,142,20,language$(83))
      Else
        ButtonGadget(#gadget_charset_back,  10+143,5+128*2+5   ,142,20,language$(0))
      EndIf
      ButtonGadget(#gadget_charset_reset,   10+143,5+128*2+5+25,142,20,language$(28))
      
      charset_createpictures_all()
      
      charset_CreatePopup()
            
      charset_choosen=-1
    EndIf
  EndIf
EndProcedure
Procedure event_charset(EventID)
  Select eventid
    Case #pb_event_closewindow
      HideWindow(#window_charset,1)
    Case #pb_event_menu
      If charsetchoosen>-1
        Select EventMenuID()
          Case #menu_charset_clear
            charset_inuse(charset_choosen)=0
            charset_createpictures_all()
            charset_choosen=-1
          Case #menu_charset_clipboard
            charset_clipboard(charset_choosen)
            charset_choosen=-1
          Case #menu_charset_load
            file$=OpenFileRequester("",standardfile$,"Image|*.png;*.bmp;*.JPEG;*.jpg;*.pcx;*.tiff;*.tga;*.IFF|Portable Network Graphics|*.png|Windows Bitmap|*.bmp|all|*.*",0)
            If file$<>"" 
              charset_loadimage(charset_choosen,file$)
              standardfile$=GetWithoutExtenstion(file$)
            EndIf
            charset_choosen=-1
          Case #menu_charset_expclip
            FI_SetClipboard(#image_charset_pic1+charset_choosen,#fic_noconvert)
            charset_choosen=-1
          Case #menu_charset_save
            file$ = SaveRequester("", standardfile$, "Portable Network Graphics|*.png|Windows Bitmap|*.bmp|all|*.*", 0,0)
            If file$<>""
              If FI_SaveImage(#image_charset_pic1+charset_choosen,file$,#fic_8BitsWU,0)
                standardfile$=GetWithoutExtenstion(file$)
              Else
                MessageRequester(#title_charset, language$(13), #PB_MessageRequester_Ok )
              EndIf
            EndIf
        EndSelect
      EndIf
    Case #pb_event_gadget
      If EventGadgetID()>=#gadget_charset_pic1 And EventGadgetID()<=#gadget_charset_pic8
        charset_choosen=EventGadgetID()-#gadget_charset_pic1
        DisplayPopupMenu(#menu_charset_popup,WindowID())
        
      Else
        Select EventGadgetID()
          Case #gadget_charset_load
            file$ = OpenFileRequester("", standardfile$, "Image|*.png;*.bmp;*.JPEG;*.jpg;*.pcx;*.tiff;*.tga;*.IFF|Portable Network Graphics|*.png|Windows Bitmap|*.bmp|all|*.*", 0)
            If file$<>""
              charset_loadcharset(file$) 
              standardfile$=GetWithoutExtenstion(file$)
            EndIf
            
          Case #gadget_charset_save
            charset_createcompleteimage()
            If charset_backcolorinuse
              MessageRequester(#title_charset, language$(5), #PB_MessageRequester_Ok )
            EndIf
            file$ = SaveRequester("", standardfile$, "Portable Network Graphics|*.png|Windows Bitmap|*.bmp|all|*.*", 0,0)
            If file$<>""
              If FI_SaveImage(#image_charset_all,file$,#fic_8BitsWU,0)
                standardfile$=GetWithoutExtenstion(file$)
              Else
                MessageRequester(#title_charset, language$(13), #PB_MessageRequester_Ok )
              EndIf
            EndIf

            FreeImage(#image_charset_all)

          Case #gadget_charset_reset
            For i=0 To 7
              charset_inuse(i)=0
            Next
            charset_createpictures_all()
            
          Case #gadget_charset_back
            If charset_autobackcolor
              i=ColorRequester()
              If i>-1 
                charset_backcolor=i
                If charset_backcolorinuse
                  MessageRequester(#title_charset, language$(5), #PB_MessageRequester_Ok )
                EndIf
                charset_autobackcolor=0
              Else
                charset_autobackcolor=1
              EndIf
            Else
              charset_autobackcolor=1
            EndIf
            
            charset_createpictures_all()
            If charset_autobackcolor
              SetGadgetText(#gadget_charset_back,language$(83))
            Else
              SetGadgetText(#gadget_charset_back, LANGUAGE$(0))
            EndIf
        EndSelect
      EndIf
  EndSelect
EndProcedure
    
 
; CursorPosition=304
; CompileThis=F:\charas.ex\charas.ex.pb
; ExecutableFormat=Windows
; EOF